import os,configparser
from ftplib import FTP, error_perm

CONFIG_FILE = 'config.ini'

def load_config(filename):
    """Charge un fichier INI et retourne l'objet ConfigParser."""
    config = configparser.ConfigParser()
    try:
        read_files = config.read(filename)
        if not read_files:
            print(f"Erreur: Impossible de lire le fichier {filename}. Assurez-vous qu'il existe.")
            sys.exit(1)
        return config
    except Exception as e:
        print(f"Erreur lors de la lecture du fichier {filename}: {e}")
        sys.exit(1)
        
def ftp_upload_dir(ftp_url, username, password, local_dir, remote_dir):
    """
    Copie récursivement un répertoire local et son contenu sur un serveur FTP
    en conservant l'arborescence.

    :param ftp_url: adresse du serveur FTP (ex: "ftp.monsite.com")
    :param username: nom d'utilisateur FTP
    :param password: mot de passe FTP
    :param local_dir: chemin du répertoire local à copier
    :param remote_dir: chemin du répertoire distant de destination
    """

    def ensure_remote_dir(path):
        """Crée récursivement les répertoires distants manquants."""
        dirs = path.strip("/").split("/")
        cwd = ""
        for d in dirs:
            cwd = f"{cwd}/{d}" if cwd else d
            try:
                ftp.mkd(cwd)
            except error_perm as e:
                # Ignore l'erreur si le répertoire existe déjà
                if not str(e).startswith("550"):
                    raise

    def upload_recursive(local_path, remote_path):
        """Copie récursivement le contenu du répertoire local."""
        for item in os.listdir(local_path):
            local_item = os.path.join(local_path, item)
            remote_item = f"{remote_path}/{item}"
            if os.path.isdir(local_item):
                ensure_remote_dir(remote_item)
                upload_recursive(local_item, remote_item)
            else:
                with open(local_item, "rb") as f:
                    ftp.storbinary(f"STOR {remote_item}", f)
                #print(f"✅ Fichier envoyé : {remote_item}")

    # Connexion FTP
    with FTP(ftp_url) as ftp:
        ftp.login(username, password)
        print(f"🔗 Connecté à {ftp_url}")

        ensure_remote_dir(remote_dir)
        upload_recursive(local_dir, remote_dir)
        print("🎉 Transfert terminé avec succès.")

def main():
    config_config = load_config(CONFIG_FILE)
    ftp_grimeco_url = config_config.get('config', 'ftp_grimeco_url').strip('"')
    ftp_grimeco_username = config_config.get('config', 'ftp_grimeco_username').strip('"')
    ftp_grimeco_password = config_config.get('config', 'ftp_grimeco_password').strip('"')
    ftp_grimeco_remote_dir = config_config.get('config', 'ftp_grimeco_remote_dir').strip('"')
    ftp_upload_dir(
        ftp_url=ftp_grimeco_url,
        username=ftp_grimeco_username,
        password=ftp_grimeco_password,
        local_dir="output_meteo",
        remote_dir=ftp_grimeco_remote_dir
    )
    
    
# Exemple d’utilisation :
if __name__ == "__main__":
    main()
