import json
import time
import threading
import sys
import subprocess      
from screeninfo import get_monitors 
from effectcontroller import EffectController
from arduinocontroller import ArduinoController
from videocontroller import VideoPlayer

# ==============================================================
# CLASSE MANAGER (Orchestre les deux écrans)
# ==============================================================
class MultiPlayerManager:
    def __init__(self,arduino):
        self.arduino=arduino
        self.players = {
            0: VideoPlayer(screen_id=0, arduino=self.arduino),
            1: VideoPlayer(screen_id=1, arduino=self.arduino)
        }
        print("🖥️ Manager initialisé avec 2 lecteurs.")

    def play_video(self, screen_id: int, json_path: str, audio_enabled: bool = True):
        # ... (Logique inchangée) ...
        if screen_id not in self.players:
            print(f"Erreur : L'écran {screen_id} n'existe pas.")
            return

        print(f"\n---> Commande reçue : Jouer '{json_path}' sur l'écran {screen_id}")
        
        self.players[screen_id].stop()
        
        self.players[screen_id].play(json_path, audio_enabled)

    def stop_video(self, screen_id: int):
        # ... (Logique inchangée) ...
        if screen_id in self.players:
            self.players[screen_id].stop()
        else:
            print(f"Erreur : L'écran {screen_id} n'existe pas.")
            
    def stop_all(self):
        # ... (Logique inchangée) ...
        print("\n🛑 Arrêt de tous les lecteurs...")
        for player in self.players.values():
            player.stop()
        print("👋 Programme terminé.")
