import customtkinter as ctk
from yt_dlp import YoutubeDL
import os
import subprocess
import tkinter as tk
import json

class AppAudio(ctk.CTk):
    def __init__(self):
        super().__init__()
        self.title("Audio Downloader")
        
        # 1. Charger la configuration ou définir par défaut
        self.config_file = "config.json"
        self.charger_config()

        self.output_dir = "mp3"
        if not os.path.exists(self.output_dir):
            os.makedirs(self.output_dir)

        self.results_data = []

        # Configuration du protocole de fermeture
        self.protocol("WM_DELETE_WINDOW", self.quitter)

        # --- UI ---
        ctk.CTkLabel(self, text="YouTube Audio Downloader", font=("Arial", 20, "bold")).pack(pady=15)
        
        search_frame = ctk.CTkFrame(self)
        search_frame.pack(pady=10, padx=20, fill="x")
        
        self.entry = ctk.CTkEntry(search_frame, placeholder_text="Mots-clés...")
        self.entry.pack(side="left", padx=10, pady=10, expand=True, fill="x")

        self.btn_search = ctk.CTkButton(search_frame, text="Rechercher", command=self.rechercher)
        self.btn_search.pack(side="right", padx=10)

        self.listbox = tk.Listbox(self, font=("Arial", 11), bg="#2b2b2b", fg="white", 
                                  selectbackground="#1f538d", borderwidth=0, highlightthickness=0)
        self.listbox.pack(pady=10, padx=20, fill="both", expand=True)
        self.listbox.bind("<<ListboxSelect>>", self.on_select)

        self.btn_download = ctk.CTkButton(self, text="Télécharger la sélection", 
                                          command=self.telecharger, state="disabled",
                                          fg_color="#2ecc71", hover_color="#27ae60")
        self.btn_download.pack(pady=15)

        self.status_label = ctk.CTkLabel(self, text="Prêt")
        self.status_label.pack(pady=5)

    def charger_config(self):
        """Restaure la position et la taille de la fenêtre"""
        if os.path.exists(self.config_file):
            with open(self.config_file, "r") as f:
                config = json.load(f)
                self.geometry(f"{config['w']}x{config['h']}+{config['x']}+{config['y']}")
        else:
            self.geometry("700x550")

    def quitter(self):
        """Sauvegarde la position et la taille avant de fermer"""
        config = {
            "w": self.winfo_width(),
            "h": self.winfo_height(),
            "x": self.winfo_x(),
            "y": self.winfo_y()
        }
        with open(self.config_file, "w") as f:
            json.dump(config, f)
        self.destroy()

    def on_select(self, event):
        if self.listbox.curselection():
            self.btn_download.configure(state="normal")

    def rechercher(self):
        query = self.entry.get()
        if not query: return
        self.status_label.configure(text="Recherche en cours...")
        self.listbox.delete(0, tk.END)
        self.results_data = []

        ydl_opts = {'quiet': True, 'noplaylist': True, 'extract_flat': True}
        with YoutubeDL(ydl_opts) as ydl:
            info = ydl.extract_info(f"ytsearch5:{query}", download=False)
            if 'entries' in info:
                for entry in info['entries']:
                    self.results_data.append({'url': entry['url'], 'title': entry['title']})
                    self.listbox.insert(tk.END, f"  {entry['title']}")
        self.status_label.configure(text="Sélectionnez un titre.")

    def telecharger(self):
        selection = self.listbox.curselection()
        if not selection: return
        
        # --- Mise à jour visuelle du bouton ---
        self.btn_download.configure(text="Traitement en cours...", fg_color="#e74c3c", state="disabled")
        self.status_label.configure(text="Téléchargement et normalisation...")
        self.update() # Force la mise à jour visuelle

        index = selection[0]
        video_info = self.results_data[index]
        
        try:
            self.process_audio(video_info)
        finally:
            # --- Remise à zéro du bouton ---
            self.btn_download.configure(text="Télécharger la sélection", fg_color="#2ecc71", state="normal")

    def process_audio(self, video_info):
        url = video_info['url']
        clean_title = "".join([c for c in video_info['title'] if c.isalnum() or c in (' ', '-', '_')]).strip()
        temp_wav = "temp_work.wav"
        final_mp3 = os.path.join(self.output_dir, f"{clean_title}.mp3")

        ydl_opts = {
            'format': 'bestaudio/best',
            'outtmpl': 'temp_work',
            'postprocessors': [{'key': 'FFmpegExtractAudio', 'preferredcodec': 'wav'}],
            'quiet': True
        }

        with YoutubeDL(ydl_opts) as ydl:
            ydl.download([url])

        # Normalisation EBU R128
        cmd = f'ffmpeg -i {temp_wav} -af loudnorm=I=-16:TP=-1.5:LRA=11 -b:a 320k "{final_mp3}" -y'
        subprocess.run(cmd, shell=True, stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL)

        if os.path.exists(temp_wav): os.remove(temp_wav)
        self.status_label.configure(text=f"Terminé : {clean_title}.mp3")

if __name__ == "__main__":
    app = AppAudio()
    app.mainloop()
