import customtkinter as ctk
import subprocess
import threading
import sys
import os

# Configuration de l'apparence
ctk.set_appearance_mode("dark")
ctk.set_default_color_theme("blue")

class App(ctk.CTk):
    def __init__(self):
        super().__init__()

        self.title("WP Offline Builder")
        self.geometry("700x500")

        # --- Layout ---
        self.grid_columnconfigure(0, weight=1)
        self.grid_rowconfigure(1, weight=1)

        # 1. Titre
        self.label = ctk.CTkLabel(self, text="WordPress Backup & Static Gen", font=ctk.CTkFont(size=20, weight="bold"))
        self.label.grid(row=0, column=0, padx=20, pady=20)

        # 2. Zone de boutons
        self.button_frame = ctk.CTkFrame(self)
        self.button_frame.grid(row=1, column=0, padx=20, pady=10, sticky="nsew")
        
        self.btn_download = ctk.CTkButton(self.button_frame, text="1. Télécharger XML", command=self.run_download)
        self.btn_download.pack(pady=10, padx=20, fill="x")

        self.btn_build = ctk.CTkButton(self.button_frame, text="2. Générer le Site (Build)", command=self.run_build, fg_color="#28a745", hover_color="#218838")
        self.btn_build.pack(pady=10, padx=20, fill="x")

        # 3. Console de sortie
        self.textbox = ctk.CTkTextbox(self, height=200, font=("Courier New", 12))
        self.textbox.grid(row=2, column=0, padx=20, pady=20, sticky="nsew")
        self.log("Système prêt. Attente d'une action...")

    def log(self, text):
        """Ajoute du texte à la console interne."""
        self.textbox.insert("end", text + "\n")
        self.textbox.see("end")

    def run_script_threaded(self, script_name):
        """Lance un script dans un thread séparé pour ne pas figer l'interface."""
        def worker():
            self.log(f">>> Lancement de {script_name}...")
            try:
                # On utilise sys.executable pour être sûr d'utiliser le même Python
                process = subprocess.Popen(
                    [sys.executable, script_name],
                    stdout=subprocess.PIPE,
                    stderr=subprocess.STDOUT,
                    text=True,
                    bufsize=1
                )
                
                for line in process.stdout:
                    self.log(line.strip())
                
                process.wait()
                if process.returncode == 0:
                    self.log(f"✅ {script_name} terminé avec succès.")
                else:
                    self.log(f"❌ Erreur dans {script_name} (Code {process.returncode})")
            
            except Exception as e:
                self.log(f"❌ Erreur critique : {str(e)}")

        threading.Thread(target=worker, daemon=True).start()

    def run_download(self):
        self.run_script_threaded("download_export_xml.py")

    def run_build(self):
        self.run_script_threaded("build.py")

if __name__ == "__main__":
    app = App()
    app.mainloop()
