import subprocess
import sys
import os

def run_script(script_name, args=[]):
    print(f"--- Running {script_name} ---")
    try:
        cmd = [sys.executable, script_name] + args
        result = subprocess.run(cmd, check=True)
        print(f"--- {script_name} completed successfully ---\n")
        return True
    except subprocess.CalledProcessError as e:
        print(f"!!! Error running {script_name}: {e}")
        return False

def main():
    # 1. Generate HTML pages from XML
    # Assumes grimeco.xml is the input file
    xml_file = "backups/last.xml"
    if not os.path.exists(xml_file):
        print(f"Error: Input file '{xml_file}' not found.")
        return

    if not run_script("wp_xml_to_html.py", [xml_file]):
        print("Build stopped due to errors.")
        return

    # 2. Generate Index and Navigation Links
    if not run_script("wp_wml_gen_index.py"):
        print("Build stopped due to errors.")
        return

    print("=== BUILD SUCCESSFUL ===")

if __name__ == "__main__":
    main()
