import requests
from datetime import datetime
import configparser
import os
import zipfile

# --- Charger la config ---
config = configparser.ConfigParser()
config.read("config.ini")

BASE_URL = config["wordpress"]["BASE_URL"]
USER = config["wordpress"]["USER"]
PASSWORD = config["wordpress"]["PASSWORD"]
DEST_FOLDER = config["backup"]["DEST_FOLDER"]

os.makedirs(DEST_FOLDER, exist_ok=True)

# --- URLs WordPress ---
login_url = f"{BASE_URL}/wp-login.php"
export_url = f"{BASE_URL}/wp-admin/export.php?download=true&content=all"

# --- Session Requests ---
session = requests.Session()

payload = {
    "log": USER,
    "pwd": PASSWORD,
    "wp-submit": "Log In",
    "redirect_to": f"{BASE_URL}/wp-admin/",
    "testcookie": "1"
}

# Login
resp = session.post(login_url, data=payload)

# Vérification de la connexion
if not any("wordpress_logged_in" in c.name for c in session.cookies):
    raise Exception("❌ Connexion WordPress échouée")

print("✅ Connexion réussie")

# Télécharger l’export XML
response = session.get(export_url)
if response.status_code != 200 or b"<?xml" not in response.content[:100]:
    raise Exception("❌ Erreur lors du téléchargement de l’export")

# Nom du fichier avec date
timestamp = datetime.now().strftime("%Y-%m-%d_%H-%M")
xml_filename = f"wordpress_export_{timestamp}.xml"
xml_path = os.path.join(DEST_FOLDER, "last.xml")

with open(xml_path, "wb") as f:
    f.write(response.content)

print(f"✅ Export XML sauvegardé : {xml_path}")

# --- Compresser en zip ---
zip_filename = f"{xml_filename}.zip"
zip_path = os.path.join(DEST_FOLDER, zip_filename)

with zipfile.ZipFile(zip_path, 'w', zipfile.ZIP_DEFLATED) as zipf:
    zipf.write(xml_path, arcname=xml_filename)

print(f"✅ Export compressé : {zip_path}")

# Optionnel : supprimer le fichier XML original
#os.remove(xml_path)
