# Documentation Technique et Utilisateur - PyBeat

## 1. Objectifs du Projet

**PyBeat** est un séquenceur rythmique logiciel (Drum Machine) développé en Python. Son objectif est de fournir une plateforme simple mais puissante pour la création de boucles rythmiques (beats), l'expérimentation musicale et l'apprentissage de la programmation audio.

Il a été conçu pour répondre aux besoins suivants :
*   **Création musicale rapide** : Interface intuitive type "step sequencer" (grille) inspirée des boîtes à rythmes classiques (TR-808, TR-909).
*   **Modularité** : Architecture séparant l'interface (UI), la logique audio et les données (MVC).
*   **Personnalisation** : Système de "Kits" de batterie basés sur des fichiers WAV, facilement extensibles par l'utilisateur.
*   **Fonctions Avancées** : Gestion de la vélocité (Ghost notes), panoramique, pitch shifting, et mode "Song" pour structurer des morceaux complets.

## 2. Dépendances Techniques

Le projet repose sur **Python 3.10+** et utilise plusieurs bibliothèques externes pour l'interface graphique et le traitement audio.

### Pré-requis Système
*   Un système d'exploitation compatible (Linux, Windows, macOS).
*   Sortie audio configurée.

### Bibliothèques Python (Requirements)
Les paquets suivants doivent être installés (via `pip install -r requirements.txt`) :

*   **`pygame`** : Moteur principal pour la gestion de l'audio (playback faible latence, mixage).
*   **`customtkinter`** : Surcouche moderne pour `tkinter` offrant un design sombre ("Dark Mode") et des widgets esthétiques.
*   **`numpy`** *(Recommandé)* : Utilisé pour les calculs audio avancés comme le "Pitch Shifting" (changement de hauteur) en temps réel. Le logiciel fonctionne sans, mais avec des fonctionnalités réduites.

### Structure des Fichiers Clés
*   **`main.py`** : Point d'entrée de l'application.
*   **`src/`** : Code source principal.
    *   `ui.py` : Gestion de l'interface graphique et des interactions utilisateur.
    *   `audio.py` : Moteur audio (chargement des samples, playback, export WAV).
    *   `models.py` : Structures de données (Grille, Pistes, État).
    *   `smart_logic.py` : Algorithmes de génération (ex: ligne de basse intelligente).
*   **`assets/kits/`** : Dossier contenant les banques de sons (chaque sous-dossier est un Kit).
*   **`saves/`** et **`presets/`** : Stockage des projets utilisateurs (JSON).

## 3. Mode Opératoire (Guide Utilisateur)

### Lancement
Exécuter la commande suivante dans le dossier du projet :
```bash
python main.py
```

### Interface Principale
L'interface est divisée en trois zones :

1.  **Barre Supérieure (Paramètres Globaux)**
    *   **BPM** : Contrôle du tempo (Battements par minute).
    *   **Steps** : Nombre de pas dans la séquence (de 4 à 32).
    *   **Kit** : Menu déroulant pour changer instantanément la banque de sons.
    *   **Swing** : Ajoute du "groove" en décalant légèrement les temps faibles.
    *   **Master Vol** : Volume général.

2.  **La Grille (Séquenceur)**
    *   Chaque ligne représente une piste (instrument : Kick, Snare, HiHat...).
    *   Chaque case représente un pas temporel (Step).
    *   **Activer une note** : Clic Gauche (Vélocité Max / Rouge-Orange).
    *   **Ghost Note** : Clic Droit ou Shift+Clic (Note plus douce / Couleur assombrie).
    *   **Contrôles de Piste** (à gauche) :
        *   `VOL` : Slider de volume individuel.
        *   `M` (Mute) : Coupe le son de la piste.
        *   `S` (Solo) : Isole la piste.
        *   `MIX` : Ouvre les réglages de Panoramique (Gauche/Droite) et de Pitch (Hauteur).
    *   **Ligne d'Accords (Chords)** : La ligne supérieure permet de définir des accords (Do Majeur, Ré Mineur...) pour piloter la génération intelligente de basse.

3.  **Barre Inférieure (Outils)**
    *   **Transport** : `PLAY`, `STOP`, `CLEAR` (effacer tout).
    *   **Song Mode** : Permet de créer une liste de lecture de motifs (Patterns) pour construire un morceau (Intro -> Couplet -> Refrain).
        *   bouton `+ ADD` : Ajoute l'état actuel de la grille à la playlist.
        *   Switch `SONG MODE` : Active l'enchaînement automatique des patterns de la playlist.
    *   **Fichiers** :
        *   `SAVE` / `LOAD` : Sauvegarder ou charger un projet complet (`.json`).
        *   `EXPORT WAV` : Génère un fichier audio haute qualité du mix actuel.

### Raccourcis Clavier
*   `Espace` : Play / Stop.
*   `Suppr` (Delete) : Effacer la grille entière.
*   `Echap` (Esc) : Stop et retour au début.

## 4. Maintenance et Développement

### Ajouter un nouveau Drum Kit
Pour ajouter des sons, il n'est pas nécessaire de modifier le code :
1.  Créer un nouveau dossier dans `assets/kits/` (ex: `Mon_Kit_Techno`).
2.  Y déposer des fichiers `.wav`.
3.  Au prochain démarrage, PyBeat détectera le kit et attribuera chaque fichier à une piste. Un fichier `kit_config.json` sera généré automatiquement dans ce dossier pour sauvegarder l'ordre et le nom des pistes.

### Architecture du Code
*   **Modification de l'UI** : Tout se passe dans `src/ui.py`. La classe `PyBeatApp` hérite de `ctk.CTk`. Les méthodes `_incremental_create_tracks` gèrent l'affichage dynamique de la grille.
*   **Moteur Audio** : `src/audio.py` gère `pygame.mixer`. La méthode `_run_loop` contient la boucle principale de lecture (Thread séparé).
    *   *Attention* : Toute modification dans `_run_loop` doit être performante pour éviter les désynchronisations rythmiques.
*   **Export WAV** : La fonction `export_wav` dans `src/audio.py` reconstruit le signal audio mathématiquement (sans enregistrer la sortie carte son), garantissant un rendu "offline" propre.

## 5. Améliorations Possibles (Roadmap)

Des pistes d'évolution pour les futurs développeurs :

1.  **Optimisation Audio** :
    *   L'export WAV actuel utilise des boucles Python simples. Migrer vers des opérations vectorielles `numpy` accélérerait drastiquement l'export de morceaux longs.
    *   Implémenter un buffer circulaire plus robuste pour éviter les micro-latences sous Windows.

2.  **Fonctionnalités Musicales** :
    *   **Support MIDI** : Permettre l'export en fichier `.mid` ou le pilotage d'instruments externes.
    *   **Effets VST/DSP** : Ajouter des effets temps réel (Reverb, Delay) sur le master ou par piste.

3.  **Interface** :
    *   Ajouter une vue "Piano Roll" pour la ligne de basse afin de permettre des mélodies plus complexes que la simple génération automatique actuelle.
    *   Thèmes de couleurs personnalisables.

---
*Documentation générée pour PyBeat - Version 2026*
