import sys
import os

# Ajouter le dossier courant au path pour permettre les imports relatifs si besoin
current_dir = os.path.dirname(os.path.abspath(__file__))
sys.path.append(current_dir)

try:
    from src.ui import PyBeatApp
except ImportError as e:
    # Fallback si lancé depuis le répertoire parent sans module
    print(f"Erreur d'import: {e}")
    print("Tentative d'import alternatif...")
    try:
        from PyBeat.src.ui import PyBeatApp
    except ImportError:
        raise

if __name__ == "__main__":
    app = PyBeatApp()
    app.mainloop()
