# Documentation Technique : Samba Manager v3.0

Cette documentation détaille l'architecture, le fonctionnement et la maintenance du projet **Samba Manager**, une suite d'outils (CLI et GUI) conçue pour simplifier la gestion des partages Samba sur les systèmes GNU/Linux, avec une optimisation particulière pour l'environnement Raspberry Pi OS.

## 1. Objectifs du Projet

Le projet **Samba Manager** est né d'un besoin de simplification de l'administration des dossiers partagés sur un réseau local. Habituellement, la configuration de Samba nécessite la modification manuelle de fichiers système sensibles et une connaissance précise des permissions Linux.

### Problèmes résolus :
*   **Accessibilité** : Évite l'édition directe et risquée du fichier `/etc/samba/smb.conf`.
*   **Portabilité** : Détection automatique des paramètres utilisateurs pour s'adapter à différents environnements sans reconfiguration manuelle.
*   **Sécurité et Fiabilité** : Mise en place d'un système de sauvegarde automatique avant chaque modification pour prévenir toute perte de données ou erreur de configuration.
*   **Expérience Utilisateur** : Passage d'une administration complexe en ligne de commande à une interface graphique (GUI) moderne et intuitive en mode sombre.

---

## 2. Dépendances

Le projet s'appuie sur des technologies standards et robustes intégrées nativement dans la plupart des distributions Linux.

### Environnement d'exécution :
*   **Python 3.x** : Langage de programmation principal.
*   **Bash/Sudo** : Pour l'exécution des commandes système avec privilèges élevés.

### Bibliothèques et Outils :
*   **Tkinter (Standard Python Library)** : Utilisée pour la création de l'interface graphique.
*   **Samba (smbd, nmbd)** : Le serveur de partage de fichiers lui-même.
*   **testparm** : Utilitaire Samba utilisé pour valider et extraire la configuration.
*   **systemctl** : Pour le rechargement dynamique du service.
*   **JSON Library** : Pour la mémorisation de l'état de la fenêtre du GUI.

---

## 3. Structure Logicielle

L'architecture est divisée en deux couches : une couche logique (CLI) et une couche présentation (GUI).

### Arborescence des fichiers :
*   `samba_tool.py` : Noyau logique (Interface en ligne de commande).
*   `samba_gui.py` : Interface graphique (Tkinter).
*   `SambaManager.desktop` : Raccourci de lancement pour le bureau.

### Architecture interne :
1.  **samba_tool.py** : Moteur effectuant le parsing de `smb.conf`, la gestion des blocs de partage (ajout/suppression) et le cycle de vie des sauvegardes (`.bak`).
2.  **samba_gui.py** : Couche d'interface utilisant `samba_tool.py` via des appels `subprocess`. Gère le thème sombre, la saisie sécurisée du mot de passe et la persistance de la fenêtre via JSON.

---

## 4. Mode Opératoire

### Installation
1.  Déployez le répertoire du projet dans un dossier dédié (ex: `~/samba/`).
2.  Attribuez les droits d'exécution aux scripts Python.
3.  Configurez le raccourci bureau (`.desktop`) pour pointer vers le bon chemin.

### Utilisation (Pas à pas)
1.  **Lancement** : Ouvrez l'application via le raccourci ou en lançant `python3 samba_gui.py`.
2.  **Consultation** : Parcourez la liste des partages existants.
3.  **Ajout** : Renseignez le nom, choisissez le dossier, et validez avec votre mot de passe sudo.
4.  **Suppression** : Sélectionnez un élément et cliquez sur supprimer.
5.  **Restauration** : Utilisez la fonction de restauration pour annuler le dernier changement.

---

## 5. Guide de Maintenance

### Gestion des Sauvegardes
Une sauvegarde automatique est créée dans `/etc/samba/smb.conf.bak` avant chaque modification.
Pour restaurer manuellement : `sudo cp /etc/samba/smb.conf.bak /etc/samba/smb.conf && sudo systemctl reload smbd`.

### Journaux et Logs
*   Consultez `/var/log/samba/log.smbd` pour les erreurs de serveur.
*   L'application affiche les erreurs immédiates dans une barre de statut.

---

## 6. Évolutions Possibles

*   Visualisation des sessions actives via `smbstatus`.
*   Gestion des quotas disque par utilisateur.
*   Interface pour la gestion des mots de passe clients (`smbpasswd`).

---
**Rédigé par l'Expert Technique Antigravity - Février 2026.**
