# Documentation Complète du Projet : Cartoonify-Me

## 1. Présentation du Projet

### Objectifs
**Cartoonify-Me** est une application de bureau conçue pour transformer des photographies en images artistiques (style cartoon, manga, esquisse ou pixel art). 
L'objectif principal est de fournir une interface simple et moderne (Glisser-Déposer) permettant aux utilisateurs de créer des avatars ou des visuels stylisés sans compétences techniques, tout en exploitant la puissance de l'Intelligence Artificielle (Deep Learning) et du traitement d'image classique.

### Public Cible
*   Créateurs de contenu (avatars réseaux sociaux, miniatures).
*   Utilisateurs souhaitant styliser leurs photos personnelles.
*   Développeurs souhaitant étudier l'intégration de PyTorch avec une interface GUI Python.

---

## 2. Fonctionnalités & Mode Opératoire

### Fonctionnalités Clés
1.  **Transformation Multi-Style** :
    *   **Styles Classiques (OpenCV)** : Effet "Comics" (Bande dessinée), "Crayon" (Sketch noir et blanc), "Pixel Art".
    *   **Styles IA (AnimeGANv2)** : "Manga" (Style K-ON), "Ghibli" (Style Paprika), "Shinkai" (Paysages détaillés).
    *   **Styles Personnalisés** : Possibilité d'importer ses propres modèles `.pt`.
2.  **Traitement Haute Définition (HD)** : Option pour traiter les images avec une résolution supérieure pour plus de détails.
3.  **Ajustements en Temps Réel** : Sliders pour régler l'intensité du lissage (Comics), la taille des pixels (Pixel Art) ou la correction des couleurs (Styles IA).
4.  **Traitement par Lot (Batch)** : Conversion automatique de tout un dossier d'images.
5.  **Vidéo "Reveal"** : Génération automatique d'une vidéo MP4 montrant une animation de transition (rideau) entre l'image originale et le résultat.
6.  **Mode Hors-Ligne** : L'application fonctionne entièrement sans internet une fois les modèles téléchargés.

### Mode Opératoire (Guide Utilisateur)

#### A. Installation et Lancement
1.  Assurez-vous d'avoir installé **Python 3.8+**.
2.  Installez les dépendances : `pip install -r requirements.txt`
3.  Pour une première utilisation, téléchargez les modèles IA : `python setup_offline.py`
4.  Lancez l'application : Double-cliquez sur `run.bat` ou via `python src/app.py`.

#### B. Utilisation Standard
1.  **Importer** : Cliquez sur le bouton "Importer une photo" ou glissez-déposez une image directement dans la fenêtre.
2.  **Choisir** : Sélectionnez un style dans le menu latéral (ex: "Manga (K-ON)").
3.  **Paramétrer** :
    *   Activez le "Mode HD" pour une meilleure qualité (plus lent).
    *   Ajustez le slider si disponible (ex: Intensitè).
4.  **Transformer** : Cliquez sur le bouton vert **"Transformer !"**.
5.  **Sauvegarder** :
    *   "Sauvegarder" : Enregistre l'image finale (JPG/PNG).
    *   "Créer Vidéo" : Génère une animation MP4 de la transformation.

#### C. Traitement par Lot (Batch)
1.  Cliquez sur le bouton bleu **"Traitement par Lot"**.
2.  Sélectionnez un dossier contenant vos images.
3.  Validez le style choisi. L'application créera un sous-dossier (ex: `cartoon_batch_20231025...`) avec toutes les images converties.

---

## 3. Architecture Technique et Dépendances

### Structure des Fichiers
Le projet est organisé pour séparer l'interface graphique de la logique métier.

*   `src/`
    *   **`app.py`** : Point d'entrée de l'application. Gère l'interface utilisateur (CustomTkinter), les événements (boutons, sliders) et le threading (pour ne pas figer l'interface pendant les calculs).
    *   **`engine.py`** : Cœur du système. Contient la classe `CartoonEngine` qui gère :
        *   Le chargement des modèles PyTorch (avec cache local).
        *   Les algorithmes OpenCV (filtre bilatéral, détection de contours).
        *   L'inférence des réseaux de neurones (redimensionnement, pré-traitement, post-traitement).
        *   La génération de vidéo (via `cv2.VideoWriter`).
    *   **`anime_gan_v2.py`** : Définition de l'architecture du modèle neuronal (utilisée en fallback pour certains poids `.pt`).
*   `models/` : Stockage local des fichiers de poids (`.pt`) téléchargés par `torch.hub`.
*   `setup_offline.py` : Script utilitaire pour pré-télécharger tous les modèles requis et configurer l'environnement hors-ligne.

### Dépendances (requirements.txt)
*   **Interface Graphique** :
    *   `customtkinter` : Wrapper moderne pour Tkinter (Design sombre/moderne).
    *   `tkinterdnd2` : Gestion du Drag & Drop natif.
*   **Traitement d'Image & IA** :
    *   `opencv-python` : Algorithmes de vision par ordinateur classiques.
    *   `Pillow` (PIL) : Manipulation basique d'images (redimensionnement, I/O).
    *   `torch` & `torchvision` : Framework Deep Learning pour exécuter les modèles AnimeGANv2.
    *   `numpy` : Calculs matriciels.

### Maintenance et Extensibilité
*   **Ajouter un style IA** : Déposez simplement un fichier `.pt` (checkpoint AnimeGAN) dans le dossier `models/custom/`. Il sera automatiquement détecté au redémarrage ou via le bouton "Importer un Style".
*   **Ajouter un style OpenCV** : Modifiez `src/engine.py` pour ajouter une méthode (ex: `process_sepia`) et mettez à jour la liste des styles dans `src/app.py` (`get_style_list`).

---

## 4. Améliorations Possibles

Pour faire évoluer le projet, voici quelques pistes d'amélioration identifiées :

1.  **Support GPU (CUDA)** :
    *   Actuellement, le moteur est forcé en mode CPU (`device='cpu'` dans `engine.py`) pour assurer la compatibilité universelle.
    *   *Amélioration* : Ajouter une détection automatique de CUDA pour accélérer le traitement (x10) sur les PC équipés de cartes NVIDIA.
2.  **Prévisualisation Live** :
    *   Implémenter un aperçu basse résolution en temps réel lors du déplacement des sliders (actuellement, le slider met à jour l'image seulement si elle a déjà été traitée, ou nécessite un re-calcul).
3.  **Formats de Sortie** :
    *   Ajouter le support pour WebP ou TIFF.
    *   Ajouter plus d'options pour la vidéo (durée, FPS configurables).
4.  **Version Web** :
    *   La logique étant isolée dans `engine.py`, il serait aisé de créer une interface Web (Flask/FastAPI) pour utiliser ce moteur sur un serveur ou dans le cloud.
5.  **Détection de Visage** :
    *   Intégrer un crop automatique sur les visages avant le traitement pour améliorer les résultats sur les portraits (les modèles AnimeGAN fonctionnent mieux sur les gros plans).

---

*Généré pour la documentation du projet Cartoonify-Me.*
