# Guide d'Installation : Cartoonify-Me

Ce document explique comment installer et configurer **Cartoonify-Me** sur un nouvel ordinateur Windows.

## Pré-requis
*   **Système d'exploitation** : Windows 10 ou 11.
*   **Connexion Internet** : Nécessaire uniquement pour l'installation initiale (Python et dépendances).
*   **Python** : La version 3.8 ou supérieure doit être installée.
    *   *Téléchargement* : [python.org](https://www.python.org/downloads/)
    *   *Important* : Cochez la case **"Add Python to PATH"** lors de l'installation.

## Contenu du dossier
*   `src/` : Le code source de l'application.
*   `models/` : Les modèles d'IA nécessaires (déjà inclus si vous avez récupéré l'archive complète, sinon ils seront téléchargés).
*   `requirements.txt` : La liste des librairies nécessaires.
*   `run.bat` : Le lanceur automatique.
*   `DOCUMENTATION.md` : Le manuel utilisateur complet.

## Étape 1 : Installation

1.  **Extraire l'archive** :
    Décompressez le fichier zip `cartoonify_install.zip` dans le dossier de votre choix (par exemple sur le Bureau ou dans Documents).

2.  **Ouvrir un terminal** :
    *   Allez dans le dossier décompressé.
    *   Cliquez dans la barre d'adresse de l'explorateur de fichiers.
    *   Tapez `cmd` et appuyez sur **Entrée**.

3.  **Installer les dépendances** :
    Dans la fenêtre noire qui s'ouvre, tapez la commande suivante (ou copiez-collez là) :
    
    ```bash
    pip install -r requirements.txt
    ```
    
    *Attendez que l'installation se termine (plusieurs barres de téléchargement peuvent apparaître).*

## Étape 2 : Lancement

Il existe deux façons de lancer l'application :

1.  **Méthode Rapide** : Double-cliquez simplement sur le fichier **`run.bat`**.
2.  **Méthode Manuelle (Terminal)** :
    ```bash
    python src/app.py
    ```

## Dépannage

*   **"Python n'est pas reconnu..."** :
    Cela signifie que Python n'est pas installé ou pas ajouté au PATH. Réinstallez Python en cochant bien "Add Python to PATH".

*   **Erreur `ModuleNotFoundError`** :
    Les dépendances ne sont pas installées. Relancez l'étape 1 (`pip install...`).

*   **Modèles manquants** :
    Si l'application se plaint de fichiers manquants, lancez le script de réparation :
    ```bash
    python setup_offline.py
    ```

---
*Profitez de vos créations !*
