# Cartoonify-Me

Cartoonify-Me est une application de bureau Windows permettant de transformer vos photos en images style cartoon, manga ou dessin artistique grâce à l'intelligence artificielle (AnimeGANv2) et des algorithmes de traitement d'image (OpenCV).

## 🚀 Fonctionnalités Principales

*   **Interface Moderne** : GUI intuitive basée sur `customtkinter` avec support du thème sombre.
*   **Styles Variés** :
    *   **Classiques (OpenCV)** : Comics, Crayon (Sketch), Pixel Art.
    *   **IA (AnimeGANv2)** : Manga (K-ON), Ghibli (Paprika), Shinkai.
    *   **Custom** : Importez vos propres modèles `.pt`.
*   **Support Drag & Drop** : Glissez-déposez vos images directement dans l'application.
*   **Mode HD** : Traitement haute définition pour des résultats plus nets.
*   **Ajustements en Temps Réel** : Sliders pour ajuster l'intensité des effets ou la correction des couleurs (selon le style).
*   **Traitement par Lot (Batch)** : Convertissez tout un dossier d'images en une seule opération.
*   **Génération de Vidéo** : Créez automatiquement une vidéo "révélation" (MP4) montrant la transition entre l'original et le résultat.
*   **Mode Hors-Ligne** : Tous les modèles sont stockés localement après la configuration initiale.

## 🛠️ Installation

1.  **Pré-requis** :
    *   Python 3.8 ou supérieur.
    *   Un environnement Windows (testé sur Windows 10/11).

2.  **Cloner ou télécharger ce dépôt**.

3.  **Installer les dépendances** :
    Il est recommandé d'utiliser un environnement virtuel (`venv`).
    ```bash
    pip install -r requirements.txt
    ```

4.  **Configuration Initiale (Téléchargement des modèles)** :
    Lancez le script d'installation pour télécharger les modèles d'IA nécessaires (une seule fois).
    ```bash
    python setup_offline.py
    ```

## 💻 Utilisation

### Lancement
Double-cliquez sur le fichier `run.bat` ou exécutez la commande suivante dans votre terminal :
```bash
python src/app.py
```

### Interface Utilisateur
1.  **Importer** : Cliquez sur "Importer une photo" ou glissez une image dans la fenêtre.
2.  **Choisir un Style** : Sélectionnez un style dans le menu déroulant à gauche.
3.  **Ajuster** : Utilisez le slider d'intensité si disponible pour le style choisi.
4.  **Transformer** : Cliquez sur le bouton vert "Transformer !".
5.  **Sauvegarder** : Exportez le résultat en image ou générez une vidéo de comparaison.

### Traitement par Lot (Batch)
1.  Cliquez sur "Traitement par Lot (Dossier)".
2.  Sélectionnez le dossier contenant vos images.
3.  L'application traitera toutes les images compatibles et les sauvegardera dans un sous-dossier `cartoon_batch_AAAAMMJJ-HHMMSS`.

## 📂 Structure du Projet

*   `src/` : Code source de l'application (`app.py`, `engine.py`, `anime_gan_v2.py`).
*   `models/` : Contient les poids des modèles IA (téléchargés via `setup_offline.py`).
*   `output/` : Dossier par défaut pour les images générées.
*   `requirements.txt` : Liste des dépendances Python.
*   `run.bat` : Script de lancement rapide pour Windows.
*   `setup_offline.py` : Script pour télécharger les modèles et configurer le mode hors-ligne.

## 🔧 Technologies Utilisées

*   **Python**
*   **CustomTkinter** (Interface graphique)
*   **PyTorch & TorchVision** (Deep Learning / AnimeGANv2)
*   **OpenCV** (Traitement d'image classique)
*   **Pillow** (Gestion des images)

## 📝 Auteur

Projet développé dans le cadre des expérimentations Antigravity.
