import torch
import os
import urllib.request
import ssl
import sys

# Ignorer erreurs SSL
ssl._create_default_https_context = ssl._create_unverified_context

def main():
    print("=== Cartoonify-Me : Configuration Mode Hors-Ligne ===")
    
    # 0. CONFIGURATION DU CACHE
    # On force le dossier 'models' du projet comme cache Torch
    project_dir = os.path.dirname(os.path.abspath(__file__))
    models_dir = os.path.join(project_dir, "models")
    
    print(f"1. Configuration du dossier de cache : {models_dir}")
    os.environ["TORCH_HOME"] = models_dir
    
    if not os.path.exists(models_dir):
        os.makedirs(models_dir)

    # 1. MODELES TORCH HUB (Manga, Paprika, Shinkai)
    # Styles mapped: "celeba_distill", "paprika", "face_paint_512_v2"
    hub_styles = ["celeba_distill", "paprika", "face_paint_512_v2"]
    
    print("\n2. Téléchargement des Modèles Officiels (TorchHub)...")
    try:
        # On charge juste pour déclencher le téléchargement
        repo = 'bryandlee/animegan2-pytorch:main'
        print(f"   Récupération du repo {repo}...")
        
        for style in hub_styles:
            print(f"   - Vérification style : {style}...")
            # Le chargement déclenche le dl si absent du cache
            torch.hub.load(repo, 'generator', pretrained=style, device='cpu')
            print("     -> OK")
            
    except Exception as e:
        print(f"   ! Erreur TorchHub : {e}")

    # 2. MODELES CUSTOM (Arcane, etc.)
    print("\n3. Téléchargement des Modèles Custom...")
    custom_dir = os.path.join(models_dir, "custom")
    if not os.path.exists(custom_dir):
        os.makedirs(custom_dir)
        
    # Liste (Nom Fichier, URL)
    # Note : Arcane utilise le fallback face_paint_512_v2 car l'officiel est introuvable
    custom_targets = [
        ("Arcane.pt", "https://github.com/bryandlee/animegan2-pytorch/raw/main/weights/face_paint_512_v2.pt"),
    ]
    
    for filename, url in custom_targets:
        dest_path = os.path.join(custom_dir, filename)
        if os.path.exists(dest_path):
            print(f"   - {filename} : Déjà présent.")
        else:
            print(f"   - {filename} : Téléchargement en cours...")
            try:
                urllib.request.urlretrieve(url, dest_path)
                print("     -> Succès")
            except Exception as e:
                print(f"     -> Echec : {e}")

    print("\n=== Terminé ! ===")
    print("Tous les modèles sont maintenant stockés localement.")
    print("Vous pouvez utiliser l'application sans connexion Internet.")
    
if __name__ == "__main__":
    main()
