import cv2
import numpy as np
import os

def cartoonize_cv(image_path, output_path):
    print(f"Processing {image_path} with OpenCV...")
    img = cv2.imread(image_path)
    if img is None:
        print("Error: Could not read image.")
        return

    # 1. Edges
    gray = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY)
    gray = cv2.medianBlur(gray, 5)
    edges = cv2.adaptiveThreshold(gray, 255, cv2.ADAPTIVE_THRESH_MEAN_C, cv2.THRESH_BINARY, 9, 9)

    # 2. Color
    color = cv2.bilateralFilter(img, 9, 300, 300)

    # 3. Combine
    cartoon = cv2.bitwise_and(color, color, mask=edges)

    # Save
    cv2.imwrite(output_path, cartoon)
    print(f"Saved to {output_path}")

if __name__ == "__main__":
    input_file = "photos/IMG-20230813-WA0028.jpg"
    output_file = "output/test_cv.jpg"
    if os.path.exists(input_file):
        cartoonize_cv(input_file, output_file)
    else:
        print(f"File not found: {input_file}")
