# Guide d'Installation - Helico

Ce fichier décrit la procédure pour installer et lancer l'application **Helico** sur une nouvelle machine.

## Prérequis

*   **Système d'exploitation :** Windows, macOS ou Linux (Ubuntu/Debian recommandé).
*   **Python :** Version 3.12 ou supérieure.
*   **Connexion Internet :** Requise pour télécharger les tuiles géographiques et les données de bâtiments (API Overpass).

## Installation

### 1. Extraire les fichiers
Décompressez l'archive `helico_package.zip` dans le dossier de votre choix.

### 2. Créer un environnement virtuel (Recommandé)
Ouvrez un terminal (ou invite de commande) dans le dossier du projet et exécutez :

**Linux / macOS :**
```bash
python3 -m venv venv
source venv/bin/activate
```

**Windows :**
```cmd
python -m venv venv
venv\Scripts\activate
```

### 3. Installer les dépendances
Une fois l'environnement activé, installez les bibliothèques requises :

```bash
pip install -r requirements.txt
```

*Note : L'installation de Panda3D et PyQt6 peut prendre quelques minutes.*

## Lancement de l'Application

Pour démarrer le simulateur :

```bash
python main.py
```

Une fenêtre de configuration s'ouvrira pour vous permettre de choisir votre point de départ.

## Dépannage

*   **Erreur "Module not found" :** Vérifiez que vous avez bien activé l'environnement virtuel et lancé `pip install`.
*   **Écran noir au lancement :** Mettez à jour vos pilotes graphiques. Panda3D nécessite un support OpenGL correct.
*   **Lenteurs :** Le premier chargement d'une zone peut être lent le temps de télécharger les données. Les lancements suivants seront plus rapides grâce au cache.
