# Documentation du Projet Helico (AeroSim)

## 1. Objectifs du Projet

Le projet **Helico** est un simulateur de vol 3D développé avec le moteur **Panda3D**. Il vise à offrir une expérience d'exploration géographique immersive et performante.

Les principaux objectifs sont :
*   **Visualisation SIG Temps Réel :** Afficher une représentation 3D de la Terre en utilisant des tuiles satellites ou cartographiques (OSM).
*   **Génération Procédurale de Bâtiments :** Reconstruire l'environnement urbain en 3D à partir des données OpenStreetMap (API Overpass), téléchargées et générées à la volée selon la position de la caméra.
*   **Navigation Fluide :** Proposer une interface de vol intuitive (type hélicoptère/drone) permettant de se déplacer librement sur de grandes distances.
*   **Performance :** Utiliser le chargement asynchrone (multithreading) pour la gestion du terrain et des bâtiments afin de maintenir une fluidité d'affichage.

## 2. Dépendances et Environnement

Le projet repose sur **Python 3.12** et utilise les bibliothèques suivantes :

### Cœur du Système
*   **Panda3D :** Moteur de rendu 3D, gestion du graphe de scène, des entrées et de la physique de base.
*   **NumPy :** Manipulation efficace des matrices de données pour la génération de terrain (heightmaps).
*   **Requests :** Gestion des requêtes HTTP pour le téléchargement des tuiles et l'interrogation de l'API Overpass.

### Interface Utilisateur
*   **PyQt6 :** Utilisé pour le lanceur (Launcher) permettant la configuration avant le démarrage du moteur 3D.

### Autres
*   **Faulthandler :** Aide au débogage des erreurs de bas niveau (segmentation faults).

L'environnement virtuel est situé dans le répertoire `venv/`.

## 3. Mode Opératoire

### Lancement de l'Application

L'application peut être lancée de deux manières :

1.  **Via le terminal :**
    ```bash
    source venv/bin/activate  # Si nécessaire
    python main.py
    ```
2.  **Via le raccourci bureau :** Utiliser le fichier `Helico.desktop` si disponible.

### Configuration au Démarrage (Launcher)

Au lancement, une fenêtre de configuration permet de définir :
*   **Position de départ :** Latitude, Longitude (en degrés décimaux) et Altitude (en mètres).
*   **Résolution :** Largeur et hauteur de la fenêtre de rendu.

### Commandes en Vol

| Touche | Action |
| :--- | :--- |
| **Z / S** | Avancer / Reculer |
| **Q / D** | Translation Gauche / Droite (Strafe) |
| **A / E** | Descendre / Monter (Altitude) |
| **Souris** | Orientation de la caméra (Yaw/Pitch) |
| **V** | Basculer l'affichage des arêtes des bâtiments (Mode fil de fer / plein) |
| **K** | Changer le type de carte (Satellite / OSM) |
| **Echap** | Quitter l'application. |

## 4. Architecture et Maintenance

La structure du projet est modulaire pour faciliter la maintenance et l'évolution.

### Structure des Fichiers

*   **`main.py`** : Point d'entrée. Initialise `ShowBase`, la fenêtre, l'éclairage et instancie les gestionnaires principaux. Définit la boucle principale via les tâches Panda3D.
*   **`src/`** : Code source du projet.
    *   **`engine/`** : Cœur de la simulation.
        *   `scene.py` : **SceneManager**. Gère le chargement tuilé du terrain (`load_radius`, `zoom`). Utilise un `ThreadPoolExecutor` pour charger les textures et élévations sans bloquer le rendu.
        *   `buildings.py` : **BuildingManager**. Interroge l'API Overpass pour récupérer les empreintes de bâtiments. Génère les maillages 3D (`GeomNode`) procéduralement. Gère une queue de priorité pour l'apparition des bâtiments.
        *   `camera.py` : **FlightCamera**. Logique de déplacement de la caméra (lissage, vitesse variable selon l'altitude).
        *   `terrain.py` : **TerrainGenerator**. Crée le maillage du sol à partir des données d'élévation.
    *   **`gis/`** : Outils géographiques.
        *   `geo_utils.py` : Conversion de coordonnées (Lat/Lon <-> Mètres), calculs de tuiles (Z/X/Y).
        *   `tiling.py` : Gestion du téléchargement et du cache des tuiles (images et élévation).
    *   **`ui/`** : Interface utilisateur.
        *   `launcher.py` : Interface PyQt6 de démarrage.
        *   `overlay.py` : Affichage tête haute (HUD) dans Panda3D (coordonnées, FPS, état du chargement).
    *   **`utils/`** : Utilitaires divers.
        *   `config_manager.py` : Chargement et sauvegarde de `config.json`.

### Configuration (`config.json`)

Les paramètres persistants sont stockés à la racine dans `config.json`. Ce fichier est mis à jour automatiquement à la fermeture pour sauvegarder la dernière position et la taille de la fenêtre.

**Exemple de contenu :**
```json
{
    "lat": 48.8566,
    "lon": 2.3522,
    "alt": 500.0,
    "map_type": "sat",
    "show_edges": false
}
```

### Points d'Attention pour la Maintenance

1.  **API Overpass :**
    *   Les endpoints sont définis dans `src/engine/buildings.py` (`OVERPASS_ENDPOINTS`).
    *   En cas de blocage ou d'erreur 429 (Too Many Requests), le système effectue une rotation automatique des serveurs.
    *   Ajouter ou modifier ces URLs si les serveurs par défaut deviennent indisponibles.

2.  **Gestion du Cache :**
    *   Les tuiles téléchargées sont stockées dans le dossier `cache/`.
    *   Il n'y a pas de purge automatique du cache implémentée. Il peut être nécessaire de le vider manuellement si l'espace disque devient critique.

3.  **Performance :**
    *   Le paramètre `max_workers` dans `SceneManager` et `BuildingManager` contrôle le nombre de threads. À ajuster selon le CPU cible (actuellement réglé à 4).
    *   Le système de "LOD" (Level of Detail) est basique (distance d'affichage).

## 5. Améliorations Possibles

Pour faire évoluer le projet, voici quelques pistes identifiées :

*   **Optimisation du Rendu (LOD) :** Implémenter des niveaux de détails géométriques pour les bâtiments. Afficher des cubes simples au loin et des géométries complexes de près.
*   **Végétation et Biosphère :** Exploiter les tags OSM `natural=tree`, `landuse=forest` pour placer des modèles d'arbres génériques.
*   **Ambiance Sonore :** Ajouter un moteur audio (bruit du vent, trafic urbain) spatialisé selon l'altitude.
*   **Météo Dynamique :** Intégrer un système de particules pour la pluie/neige et du brouillard volumétrique pour masquer le "clipping" à l'horizon.
*   **Mise en Cache Avancée :** Implémenter une stratégie LRU (Least Recently Used) pour nettoyer automatiquement le dossier `cache/`.
*   **Interface In-Game :** Ajouter une mini-carte (minimap) et un menu de configuration accessible sans redémarrer (touche Echap -> Menu).
