# Helico - Simulateur de Vol 3D

**Helico** est un simulateur de vol immersif développé en Python avec le moteur Panda3D. Il vous permet d'explorer le monde réel en 3D grâce à la génération procédurale de bâtiments et l'utilisation de données cartographiques (OpenStreetMap / Satellite).

## Objectifs

*   **Exploration :** Voler n'importe où sur Terre avec une caméra libre.
*   **Visualisation :** Reconstruire l'environnement urbain en 3D en temps réel.
*   **Performance :** Chargement asynchrone des données pour une expérience fluide.

## Fonctionnalités Clés

*   **Rendu Hybride :** Sol texturé (Satellite ou Plan) et bâtiments 3D générés depuis OSM.
*   **Cycle Jour/Nuit :** Simulation de l'éclairage.
*   **Interface de Vol :** Contrôles intuitifs (Clavier/Souris).
*   **Paramétrage :** Choix de la position de départ (Lat/Lon) et de l'altitude.

## Utilisation

### Commandes

*   **Z / S** : Avancer / Reculer
*   **Q / D** : Pas chassés (Strafe) Gauche / Droite
*   **A / E** : Descendre / Monter
*   **Souris** : Orienter la caméra
*   **V** : Afficher/Masquer les arêtes des bâtiments
*   **K** : Changer le fond de carte (Sat/OSM)
*   **Echap** : Quitter

## Structure du Projet

*   `main.py` : Script principal.
*   `src/engine/` : Moteur 3D (Gestion de la scène, Bâtiments, Caméra).
*   `src/gis/` : Outils géographiques et tuilage.
*   `src/ui/` : Interface utilisateur (Launcher, Overlay).
*   `requirements.txt` : Liste des dépendances Python.
*   `config.json` : Sauvegarde de la configuration.

## Améliorations Possibles

Le projet est conçu pour être étendu. Voici quelques idées :
*   Ajout de la végétation (arbres 3D).
*   Simulation météo (pluie, brouillard).
*   Amélioration du modèle de vol (inertie, physique plus réaliste).
*   Support des manettes de jeu.

---
*Généré automatiquement par l'assistant Antigravity.*
