import sys
from PyQt6.QtWidgets import QApplication, QDialog, QVBoxLayout, QHBoxLayout, QLabel, QLineEdit, QPushButton, QFormLayout
from PyQt6.QtCore import Qt

class LauncherDialog(QDialog):
    def __init__(self, config):
        super().__init__()
        self.config = config
        self.result_config = config.copy()
        
        self.init_ui()
        
    def init_ui(self):
        self.setWindowTitle("Configuration AeroSim")
        self.setMinimumWidth(400)
        
        layout = QVBoxLayout()
        form = QFormLayout()
        
        self.lat_edit = QLineEdit(str(self.config["lat"]))
        self.lon_edit = QLineEdit(str(self.config["lon"]))
        self.alt_edit = QLineEdit(str(self.config["alt"]))
        self.width_edit = QLineEdit(str(self.config["win_width"]))
        self.height_edit = QLineEdit(str(self.config["win_height"]))
        
        form.addRow("Latitude :", self.lat_edit)
        form.addRow("Longitude :", self.lon_edit)
        form.addRow("Altitude (m) :", self.alt_edit)
        form.addRow("Largeur Fenêtre :", self.width_edit)
        form.addRow("Hauteur Fenêtre :", self.height_edit)
        
        layout.addLayout(form)
        
        buttons = QHBoxLayout()
        btn_start = QPushButton("Démarrer Simulation")
        btn_start.clicked.connect(self.on_start)
        btn_cancel = QPushButton("Annuler")
        btn_cancel.clicked.connect(self.reject)
        
        buttons.addWidget(btn_start)
        buttons.addWidget(btn_cancel)
        layout.addLayout(buttons)
        
        self.setLayout(layout)
        
    def on_start(self):
        try:
            self.result_config["lat"] = float(self.lat_edit.text())
            self.result_config["lon"] = float(self.lon_edit.text())
            self.result_config["alt"] = float(self.alt_edit.text())
            self.result_config["win_width"] = int(self.width_edit.text())
            self.result_config["win_height"] = int(self.height_edit.text())
            self.accept()
        except ValueError:
            pass

def run_launcher(config):
    app = QApplication(sys.argv)
    dialog = LauncherDialog(config)
    res = None
    if dialog.exec() == QDialog.DialogCode.Accepted:
        res = dialog.result_config
    
    # Nettoyage explicite pour libérer le contexte OpenGL si Qt en a créé un
    del dialog
    del app
    return res
