import json
import os

CONFIG_FILE = "config.json"

DEFAULT_CONFIG = {
    "lat": 45.83,
    "lon": 6.86,
    "alt": 500.0,
    "win_x": 100,
    "win_y": 100,
    "win_width": 1280,
    "win_height": 720,
    "show_edges": False,
    "map_type": "osm"
}

def load_config():
    if os.path.exists(CONFIG_FILE):
        try:
            with open(CONFIG_FILE, "r") as f:
                return {**DEFAULT_CONFIG, **json.load(f)}
        except Exception:
            return DEFAULT_CONFIG
    return DEFAULT_CONFIG

def save_config(config):
    try:
        with open(CONFIG_FILE, "w") as f:
            json.dump(config, f, indent=4)
    except Exception as e:
        print(f"Erreur sauvegarde config: {e}")
