
from typing import NamedTuple, Tuple

class Rect(NamedTuple):
    x: float
    y: float
    width: float
    height: float

    @property
    def right(self) -> float:
        return self.x + self.width

    @property
    def bottom(self) -> float:
        return self.y + self.height

def check_collision(rect1: Rect, rect2: Rect) -> bool:
    """
    Vérifie si deux rectangles se chevauchent.
    Les rectangles sont définis par (x, y, width, height).
    Retourne True s'il y a collision, False sinon.
    """
    # Si l'un est à gauche de l'autre
    if rect1.right <= rect2.x or rect2.right <= rect1.x:
        return False
    
    # Si l'un est au-dessus de l'autre
    if rect1.bottom <= rect2.y or rect2.bottom <= rect1.y:
        return False

    return True

def is_within_bounds(inner_rect: Rect, outer_rect: Rect) -> bool:
    """
    Vérifie si inner_rect est entièrement contenu dans outer_rect.
    """
    return (inner_rect.x >= outer_rect.x and
            inner_rect.y >= outer_rect.y and
            inner_rect.right <= outer_rect.right and
            inner_rect.bottom <= outer_rect.bottom)
