# Documentation du Projet PAO (Publication Assistée par Ordinateur)

## 1. Objectifs du Projet
Le projet **PAO Zone-Based** est une application de bureau légère destinée à la création de documents mis en page graphiquement. Contrairement aux traitements de texte classiques, elle fonctionne sur un principe de **zones** (blocs de texte ou d'images) positionnables librement sur une page, similaire à des outils comme Microsoft Publisher ou Adobe InDesign (en version simplifiée).

**Buts principaux :**
- Permettre un positionnement précis des éléments (coordonnées X/Y).
- Offrir une interface intuitive avec manipulation directe (Drag & Drop, Redimensionnement).
- Exporter les documents vers des formats standards (PDF, HTML, Markdown) pour la diffusion.

---

## 2. Dépendances et Prérequis
Le projet est développé en **Python 3** (version 3.10+ recommandée).

### Librairies Tierces
Les dépendances sont listées dans `requirements.txt` :
- `PySide6>=6.5.0` : Framework GUI Qt pour l'interface graphique.
- `pyenchant` : Bibliothèque de correction orthographique.

### Installation
```bash
pip install -r requirements.txt
```

> **Note**: Pour que `pyenchant` fonctionne sous Windows, il peut être nécessaire d'installer des dictionnaires supplémentaires ou une version binaire pré-compilée si l'installation pip standard échoue.

---

## 3. Structure du Projet
L'architecture suit une séparation claire entre le modèle de données, la logique métier et l'interface graphique.

```
pao/
├── main.py                 # Point d'entrée de l'application
├── requirements.txt        # Dépendances pip
├── core/                   # Logique métier et modèles
│   ├── document.py         # Modèles de données (Document, Page, Zone)
│   ├── geometry.py         # Utilitaires géométriques (Rect, Collisions)
│   ├── serializers.py      # Chargement/Sauvegarde (JSON) et Exports (PDF/HTML/MD)
│   └── undo_redo.py        # Gestionnaire d'historique (Command Pattern)
├── gui/                    # Interface Utilisateur (PySide6)
│   ├── main_window.py      # Fenêtre principale et gestionnaire d'événements global
│   ├── canvas.py           # Scène graphique (Grille, Vue)
│   ├── items/              # Objets graphiques (TextZoneItem, ImageZoneItem)
│   ├── panels/             # Panneaux latéraux (Propriétés)
│   └── utils/              # Widgets utilitaires (SpellCheckTextEdit)
└── resources/              # Icônes et assets statiques
```

---

## 4. Mode Opératoire

### Lancement
Exécuter le fichier principal :
```bash
python main.py
```

### Fonctionnalités Clés
1.  **Gestion des Pages** : Ajouter/Supprimer des pages, modifier leur format (A4 par défaut).
2.  **Zones** :
    - **Créer** : Drag & Drop depuis la barre d'outils ou utiliser les boutons "Ajouter Texte/Image".
    - **Manipuler** : Sélectionner, déplacer, redimensionner à la souris.
    - **Propriétés** : Modifier géométrie, police, couleur via le panneau latéral.
3.  **Outils d'Édition** :
    - **Zoom/Grille** : Zoomer pour la précision, activer la grille pour l'alignement.
    - **Alignement** : Aligner plusieurs objets (Gauche, Centre, Droite, etc.).
    - **Formatage** : Gras, Italique, Souligné.
    - **Undo/Redo** : Annuler ou refaire les actions (Ctrl+Z / Ctrl+Y).
4.  **Exportation** :
    - **PDF** : Pour l'impression ou la distribution propre.
    - **HTML** : Pour le web (layout absolu).
    - **Markdown** : Pour la documentation (structure logique linéarisée).

---

## 5. Maintenance et Extension

### Ajouter un nouveau Type de Zone
1.  Créer une classe modèle dans `core/document.py` (héritant de `ZoneModel`).
2.  Créer un item graphique dans `gui/items/` (héritant de `ZoneItem`).
3.  Mettre à jour `ProjectSerializer` dans `core/serializers.py` pour sauvegarder/charger les nouveaux attributs.
4.  Ajouter la logique d'interaction dans `gui/main_window.py`.

### Ajouter un Format d'Export
1.  Créer une classe `Exporateur` dans `core/serializers.py` (ex: `DocxExporter`).
2.  Implémenter une méthode statique `export(document, path)`.
3.  Ajouter une action dans le menu/toolbar de `gui/main_window.py`.

### Gestion des Icônes
Les icônes sont situées dans `resources/`. Le code les charge via `load_icon(name)` dans `main_window.py`. Pour ajouter une icône, placer le fichier SVG dans `resources/` avec le préfixe `icon_` (ex: `icon_monoutil.svg`).

---

## 6. Améliorations Possibles
Liste non-exhaustive d'évolutions identifiées :

- **Support SVG/Vectoriel** : Permettre le dessin de formes simples (lignes, rectangles, cercles) directement dans l'application.
- **Calques (Layers)** : Ajouter un panneau pour gérer l'ordre d'affichage (Z-index) plus finement.
- **Styles Globaux** : Créer un gestionnaire de styles (comme CSS) pour appliquer rapidement des formats prédéfinis aux blocs de texte.
- **Import PDF** : Implémenter le moteur d'importation (basé sur `PyMuPDF`) pour convertir des documents existants en projets éditables (actuellement à l'état de concept).
- **Groupement** : Fonctionnalité pour grouper plusieurs zones et les déplacer ensemble.

---
*Document généré le 04/02/2026. Version du projet : 0.2*
