
from PySide6.QtWidgets import QGraphicsRectItem, QGraphicsItem
from PySide6.QtCore import Qt, QPointF
from PySide6.QtGui import QBrush, QColor, QPen, QCursor

class HandleItem(QGraphicsRectItem):
    top_left = 0
    top_right = 1
    bottom_left = 2
    bottom_right = 3
    
    def __init__(self, position_flag, parent):
        # Taille 8x8, centré sur 0,0 localement pour faciliter le placement
        super().__init__(-4, -4, 8, 8, parent)
        self.position_flag = position_flag
        self.setBrush(QBrush(QColor("white")))
        self.setPen(QPen(QColor("black"), 1))
        
        # Le handle n'est pas "Movable" au sens QGraphcisItem (pas de déplacement libre)
        # Mais on gère les événements souris manuellement
        self.setFlag(QGraphicsItem.ItemIsMovable, False) 
        self.setFlag(QGraphicsItem.ItemSendsGeometryChanges, True)
        self.setCursor(self.get_cursor())
        self.setZValue(100) # Toujours au-dessus du contenu parent
        
    def get_cursor(self):
        if self.position_flag in [self.top_left, self.bottom_right]:
            return QCursor(Qt.SizeFDiagCursor)
        else:
            return QCursor(Qt.SizeBDiagCursor)

    def update_position(self, rect):
        """Place le handle au bon coin du rect parent (local coords)."""
        if self.position_flag == self.top_left:
            self.setPos(rect.topLeft())
        elif self.position_flag == self.top_right:
            self.setPos(rect.topRight())
        elif self.position_flag == self.bottom_left:
            self.setPos(rect.bottomLeft())
        elif self.position_flag == self.bottom_right:
            self.setPos(rect.bottomRight())

    def mousePressEvent(self, event):
        self._start_pos = event.scenePos()
        self._start_parent_rect = self.parentItem().rect()
        self._start_parent_pos = self.parentItem().pos()
        # Important : Accepter l'événement pour recevoir les mouseMoveEvent suivants
        event.accept() 

    def mouseMoveEvent(self, event):
        # Délègue le calcul au parent
        if self.parentItem():
            self.parentItem().interactive_resize(self.position_flag, event.scenePos())
            # On ne rappelle pas super() pour éviter le déplacement par défaut
    
    def mouseReleaseEvent(self, event):
        super().mouseReleaseEvent(event)
