
from PySide6.QtWidgets import QGraphicsPixmapItem
from PySide6.QtGui import QPixmap, Qt
from gui.items.zone_item import ZoneItem

class ImageZoneItem(ZoneItem):
    def __init__(self, x, y, w, h, image_path=None):
        super().__init__(x, y, w, h)
        self.pixmap_item = QGraphicsPixmapItem(self)
        self.image_path = image_path
        
        if image_path:
            self.load_image(image_path)
            
    def load_image(self, path):
        self.image_path = path
        pixmap = QPixmap(path)
        if not pixmap.isNull():
            self.pixmap_item.setPixmap(pixmap)
            self.fit_image()

    def fit_image(self):
        """Ajuste l'échelle de l'image pour tenir dans la zone (aspect ratio preserved)."""
        if self.pixmap_item.pixmap().isNull():
            return
            
        rect = self.rect()
        pix_size = self.pixmap_item.pixmap().size()
        
        # Ratios
        rw = rect.width() / pix_size.width()
        rh = rect.height() / pix_size.height()
        scale = min(rw, rh)
        
        self.pixmap_item.setScale(scale)
        
        # Centrer
        new_w = pix_size.width() * scale
        new_h = pix_size.height() * scale
        
        off_x = (rect.width() - new_w) / 2
        off_y = (rect.height() - new_h) / 2
        
        self.pixmap_item.setPos(off_x, off_y)

    def setRect(self, x, y, w, h):
        super().setRect(x, y, w, h)
        self.fit_image()
