from PySide6.QtWidgets import QGraphicsTextItem, QGraphicsItem, QMenu
from PySide6.QtGui import QFont, QColor, QBrush, QTextCursor
from PySide6.QtCore import Qt, QRectF
from gui.items.zone_item import ZoneItem
from gui.utils.spell_checker import SpellHighlighter
import enchant

class TextZoneItem(ZoneItem):
    def __init__(self, x, y, w, h, text="Texte par défaut"):
        super().__init__(x, y, w, h)
        self.text_item = QGraphicsTextItem(text, self)
        self.text_item.setDefaultTextColor(QColor("white")) # Contraste sur fond gris
        self.text_item.setTextInteractionFlags(Qt.TextEditorInteraction)
        self.text_item.setPos(5, 5) # Padding
        
        # Correcteur orthographique
        self.spell_highlighter = SpellHighlighter(self.text_item.document())
        
        # Dictionary for suggestions
        try:
            self.dictionary = enchant.Dict("fr_FR")
        except:
            try:
                self.dictionary = enchant.Dict("fr")
            except:
                self.dictionary = None
        
        # Config par défaut
        font = QFont("Arial", 12)
        self.text_item.setFont(font)
        
        # Ajuster la largeur du texte pour le wrapping (si besoin)
        self.text_item.setTextWidth(w - 10)

    def setRect(self, x, y, w, h):
        super().setRect(x, y, w, h)
        if hasattr(self, 'text_item'):
            self.text_item.setTextWidth(w - 10)
            # Check overflow here (Alerte visuelle)
            doc_h = self.text_item.document().size().height()
            if doc_h > h - 10:
                # Indiquer overflow (ex: bordure rouge)
                pass

    def paint(self, painter, option, widget):
        super().paint(painter, option, widget)
        
        # Check Overflow
        # TextItem is at 5,5.
        # Height available = self.rect().height() - 10 (padding)
        # We compare content height.
        
        doc_h = self.text_item.document().size().height()
        available_h = self.rect().height() - 10
        
        if doc_h > available_h:
            # Draw overflow indicator (small red square at bottom right)
            painter.setPen(Qt.NoPen)
            painter.setBrush(QBrush(QColor("red")))
            
            w = self.rect().width()
            h = self.rect().height()
            
            # Indicator size 8x8
            painter.drawRect(w - 12, h - 12, 8, 8)
            
            # Change geometry border to warn user? (Optional, maybe too intrusive)
            # painter.setPen(QPen(QColor("red"), 1, Qt.DashLine))
            # painter.setBrush(Qt.NoBrush)
            # painter.drawRect(0, 0, w, h)
