
import re
import enchant
from PySide6.QtGui import QSyntaxHighlighter, QTextCharFormat, QColor

class SpellHighlighter(QSyntaxHighlighter):
    def __init__(self, parent=None):
        super().__init__(parent)
        
        self.dictionary = None
        
        # Tentative de chargement du dictionnaire français
        lang_attempts = ["fr_FR", "fr"]
        for lang in lang_attempts:
            try:
                self.dictionary = enchant.Dict(lang)
                break
            except enchant.DictNotFoundError:
                continue
                
        if not self.dictionary:
            print("DEBUG: SpellHighlighter - Dictionary NOT loaded.")
        else:
            # print(f"DEBUG: SpellHighlighter - Dictionary loaded: {self.dictionary.tag}")
            pass

        # Format pour le soulignement des erreurs
        self.error_format = QTextCharFormat()
        self.error_format.setUnderlineColor(QColor("red"))
        self.error_format.setUnderlineStyle(QTextCharFormat.WaveUnderline)

    def highlightBlock(self, text):
        if not self.dictionary:
            return

        # Regex simple pour trouver les mots (incluant les accents français)
        # On cherche des séquences de caractères alphanumériques
        expression = r"\b[\w'-]+\b"
        
        for match in re.finditer(expression, text):
            word = match.group()
            # Vérifier si le mot est correctement orthographié
            # On ignore les mots qui contiennent des chiffres pour simplifier
            if not any(char.isdigit() for char in word):
                # check() retourne True si correct, False sinon
                if not self.dictionary.check(word):
                    # Souligner le mot incorrect
                    self.setFormat(match.start(), match.end() - match.start(), self.error_format)
