# Guide d'Installation - PAO Zone-Based

Ce document explique comment installer et lancer l'application PAO Zone-Based sur un nouvel ordinateur (Windows, Mac ou Linux).

## Prérequis

1.  **Python** : Vous devez avoir Python installé sur votre machine (version **3.10** ou supérieure recommandée).
    - Téléchargement : [python.org](https://www.python.org/downloads/)
    - **Important (Windows)** : Lors de l'installation, cochez la case **"Add Python to PATH"**.

## Installation

### 1. Extraire les fichiers
Décompressez l'archive `pao_project.zip` dans le dossier de votre choix (ex: `Documents/MesProjets/pao`).

### 2. Ouvrir un terminal
- **Windows** : Ouvrez le dossier dans l'Explorateur, tapez `cmd` dans la barre d'adresse et faites Entrée.
- **Mac/Linux** : Clic droit dans le dossier > "Ouvrir dans un terminal".

### 3. Créer un environnement virtuel (Recommandé)
Cela permet d'isoler les dépendances du projet.

**Windows :**
```cmd
python -m venv venv
venv\Scripts\activate
```

**Mac/Linux :**
```bash
python3 -m venv venv
source venv/bin/activate
```

_(Une fois activé, vous devriez voir `(venv)` apparaître au début de la ligne de commande)_

### 4. Installer les dépendances
Exécutez la commande suivante pour installer les bibliothèques nécessaires (PySide6, etc.) :

```bash
pip install -r requirements.txt
```

> **Note**: Si vous rencontrez une erreur avec `pyenchant` sous Windows, assurez-vous d'avoir installé une version de Python compatible ou vérifiez la documentation de pyenchant.

## Lancement

Une fois l'installation terminée, lancez l'application avec :

```bash
python main.py
```

## Résolution de problèmes courants

- **"Module not found: PySide6"** : Vérifiez que votre environnement virtuel est bien activé et que vous avez lancé la commande `pip install`.
- **Problème d'affichage** : L'application utilise Qt. Si l'affichage est flou sous Windows, vérifiez les paramètres de mise à l'échelle de votre écran (clic droit sur `python.exe` > Propriétés > Compatibilité > Modifier les paramètres PPP élevés).

---
*Projet PAO Zone-Based - v0.2*
