# Guide d'Installation - Synthétiseur MIDI Python

Ce document explique comment installer et lancer l'application de synthétiseur MIDI sur votre ordinateur.

## 1. Pré-requis Système

Avant de commencer, vous devez installer :

*   **Python 3.8** ou plus récent : [python.org](https://www.python.org/downloads/)
*   **FluidSynth** : Nécessaire pour le moteur d'instruments réalistes.
    *   *Windows* : Téléchargez les binaires ou installez via un gestionnaire de paquets.
    *   *macOS* : `brew install fluidsynth`
    *   *Linux* : `sudo apt install fluidsynth`

## 2. Téléchargement des Sons (SoundFonts) ⚠️

Pour réduire la taille de l'archive, les fichiers de sons (.sf2) ne sont pas inclus.
**Vous devez télécharger une banque de sons SoundFont pour utiliser les instruments réalistes.**

1.  Téléchargez une SoundFont de qualité, par exemple :
    *   **FluidR3_GM** (Recommandé, ~140Mo) : [Télécharger sur HammerSound](http://www.hammersound.net/) ou via les dépôts Linux.
    *   **GeneralUser GS** : Une alternative légère.
2.  Placez le fichier `.sf2` téléchargé dans le dossier `sounds/` de l'application.

## 3. Installation de l'Application

1.  **Décompressez l'archive** `piano_app.zip`.
2.  Ouvrez un terminal dans le dossier décompressé.

3.  Créez un environnement virtuel (recommandé) :
    ```bash
    python -m venv .venv
    ```

4.  Activez l'environnement virtuel :
    *   *Windows* : `.venv\Scripts\activate`
    *   *macOS/Linux* : `source .venv/bin/activate`

5.  Installez les dépendances :
    ```bash
    pip install -r requirements.txt
    ```

## 4. Lancement

Une fois installé et la SoundFont placée dans le dossier `sounds/` :

**Interface Graphique (Recommandé) :**
```bash
python main_synth.py --gui
```

**Mode Console :**
```bash
python main_synth.py
```

*Note : Au premier lancement, allez dans les réglages (si disponible) ou utilisez le sélecteur de fichiers pour indiquer l'emplacement de votre fichier .sf2 si nécessaire.*
