import pygame
import random
from utils import BLOCK_SIZE, WINDOW_WIDTH, WINDOW_HEIGHT, FOOD_COLOR, FOOD_SPAWN_MARGIN

class Food:
    def __init__(self):
        self.position = [0, 0]
        self.respawn()

    def respawn(self):
        """Génère une nouvelle position aléatoire pour la nourriture."""
        # Éviter les bords : indices de FOOD_SPAWN_MARGIN à (NB_BLOCKS - 1 - FOOD_SPAWN_MARGIN)
        cols = WINDOW_WIDTH // BLOCK_SIZE
        rows = WINDOW_HEIGHT // BLOCK_SIZE
        
        x = random.randint(FOOD_SPAWN_MARGIN, cols - 1 - FOOD_SPAWN_MARGIN) * BLOCK_SIZE
        y = random.randint(FOOD_SPAWN_MARGIN, rows - 1 - FOOD_SPAWN_MARGIN) * BLOCK_SIZE
        self.position = [x, y]

    def draw(self, surface):
        """Dessine la nourriture."""
        pygame.draw.rect(surface, FOOD_COLOR, (self.position[0], self.position[1], BLOCK_SIZE, BLOCK_SIZE))
