# Guide d'Installation - Neo-Snake 3000

Merci d'avoir téléchargé Neo-Snake 3000 ! Suivez ces instructions pour installer et lancer le jeu sur votre ordinateur.

## Prérequis

Vous devez avoir **Python 3** installé sur votre machine.
- Pour vérifier si Python est installé, ouvrez un terminal et tapez : `python --version` ou `python3 --version`.
- Si ce n'est pas installé, téléchargez-le depuis [python.org](https://www.python.org/downloads/).

## Installation

1.  **Extraire les fichiers** : Décompressez l'archive `snake_game.zip` dans un dossier de votre choix.
2.  **Ouvrir un terminal** : Naviguez vers ce dossier via votre terminal ou invite de commande.

### Création d'un environnement virtuel (Recommandé)

Il est conseillé d'utiliser un environnement virtuel pour ne pas perturber votre installation Python globale.

**Sous Windows :**
```bash
python -m venv venv
venv\Scripts\activate
```

**Sous macOS / Linux :**
```bash
python3 -m venv venv
source venv/bin/activate
```

### Installation des dépendances

Une fois l'environnement activé (ou directement si vous ne souhaitez pas en utiliser), installez les librairies nécessaires :

```bash
pip install -r requirements.txt
```

## Lancement du Jeu

Pour lancer le jeu, exécutez la commande suivante dans le terminal (assurez-vous d'être dans le dossier du jeu) :

```bash
python main.py
```
*(ou `python3 main.py` selon votre système)*

Alternativement, sous Linux/macOS, vous pouvez utiliser le script fourni :
```bash
./run_game.sh
```
(Pensez à le rendre exécutable avec `chmod +x run_game.sh` si nécessaire)

Amusez-vous bien !
