import pygame
from utils import BLOCK_SIZE, SNAKE_COLOR, WINDOW_WIDTH, WINDOW_HEIGHT

class Snake:
    def __init__(self):
        self.reset()
    
    def reset(self):
        # Position initiale au centre
        x = WINDOW_WIDTH // 2
        y = WINDOW_HEIGHT // 2
        # Le serpent commence avec une taille de 3 blocs
        self.body = [[x, y], [x - BLOCK_SIZE, y], [x - 2 * BLOCK_SIZE, y]]
        self.direction = [BLOCK_SIZE, 0] # Start moving right
        self.grow = False

    def handle_input(self, key):
        """Gère les entrées clavier pour changer la direction."""
        if key == pygame.K_UP and self.direction[1] == 0:
            self.direction = [0, -BLOCK_SIZE]
        elif key == pygame.K_DOWN and self.direction[1] == 0:
            self.direction = [0, BLOCK_SIZE]
        elif key == pygame.K_LEFT and self.direction[0] == 0:
            self.direction = [-BLOCK_SIZE, 0]
        elif key == pygame.K_RIGHT and self.direction[0] == 0:
            self.direction = [BLOCK_SIZE, 0]

    def move(self):
        """Déplace le serpent et gère la croissance."""
        head = self.body[0]
        new_head = [head[0] + self.direction[0], head[1] + self.direction[1]]
        
        self.body.insert(0, new_head)
        
        if not self.grow:
            self.body.pop()
        else:
            self.grow = False

    def check_collision(self):
        """Vérifie les collisions avec les murs ou soi-même."""
        head = self.body[0]
        
        # Collision avec les murs
        if (head[0] < 0 or head[0] >= WINDOW_WIDTH or
            head[1] < 0 or head[1] >= WINDOW_HEIGHT):
            return True
        
        # Collision avec soi-même (ne pas vérifier la tête avec elle-même)
        if head in self.body[1:]:
            return True
            
        return False

    def draw(self, surface):
        """Dessine le serpent."""
        for segment in self.body:
            pygame.draw.rect(surface, SNAKE_COLOR, (segment[0], segment[1], BLOCK_SIZE, BLOCK_SIZE))
