import pygame
from utils import TEXT_COLOR, WINDOW_WIDTH, WINDOW_HEIGHT, load_highscores

class UI:
    def __init__(self):
        self.font = pygame.font.Font(None, 36)
        self.large_font = pygame.font.Font(None, 72)
        self.highscores = load_highscores()

    def draw_score(self, surface, score, highscores):
        """Affiche le score actuel et le meilleur score absolu."""
        score_text = self.font.render(f"Score: {score}", True, TEXT_COLOR)
        surface.blit(score_text, (10, 10))
        
        # Affiche le meilleur score global
        best_score = highscores[0]
        highscore_text = self.font.render(f"Record: {best_score['score']} ({best_score['name']})", True, TEXT_COLOR)
        surface.blit(highscore_text, (WINDOW_WIDTH - highscore_text.get_width() - 10, 10))

    def draw_menu(self, surface, difficulty):
        """Affiche le menu principal avec sélection de la difficulté."""
        title_text = self.large_font.render("Neo-Snake 3000", True, (0, 255, 136)) # Vert Néon
        instruction_text = self.font.render("Appuyez sur ESPACE pour jouer", True, TEXT_COLOR)
        
        # Affichage de la difficulté
        diff_text = self.font.render(f"Difficulté: < {difficulty} > (Flèches Gauche/Droite)", True, (0, 255, 255))

        surface.blit(title_text, (WINDOW_WIDTH // 2 - title_text.get_width() // 2, WINDOW_HEIGHT // 4))
        surface.blit(instruction_text, (WINDOW_WIDTH // 2 - instruction_text.get_width() // 2, WINDOW_HEIGHT // 2))
        surface.blit(diff_text, (WINDOW_WIDTH // 2 - diff_text.get_width() // 2, WINDOW_HEIGHT // 2 + 50))

    def draw_game_over(self, surface, score, new_highscore_rank=None, highscores=[]):
        """Affiche l'écran de fin de partie avec le Top 3."""
        game_over_text = self.large_font.render("GAME OVER", True, (255, 0, 85)) # Rouge Néon
        score_text = self.font.render(f"Score Final: {score}", True, TEXT_COLOR)
        
        surface.blit(game_over_text, (WINDOW_WIDTH // 2 - game_over_text.get_width() // 2, WINDOW_HEIGHT // 4))
        surface.blit(score_text, (WINDOW_WIDTH // 2 - score_text.get_width() // 2, WINDOW_HEIGHT // 4 + 60))
        
        # Affichage du Top 3
        y_offset = WINDOW_HEIGHT // 2
        header_text = self.font.render("--- TOP 3 ---", True, TEXT_COLOR)
        surface.blit(header_text, (WINDOW_WIDTH // 2 - header_text.get_width() // 2, y_offset))
        
        for i, entry in enumerate(highscores):
            color = (255, 215, 0) if i == 0 else TEXT_COLOR # Or pour le 1er
            text = f"{i+1}. {entry['name']} - {entry['score']}"
            score_line = self.font.render(text, True, color)
            surface.blit(score_line, (WINDOW_WIDTH // 2 - score_line.get_width() // 2, y_offset + 30 + i * 30))

        if new_highscore_rank is not None:
             # Le texte d'invite sera géré par draw_input ou une méthode dédiée
             pass

        restart_text = self.font.render("R: Rejouer | Q: Quitter", True, (150, 150, 150))
        surface.blit(restart_text, (WINDOW_WIDTH // 2 - restart_text.get_width() // 2, WINDOW_HEIGHT - 50))

    def draw_input(self, surface, name):
        """Affiche le nom en cours de saisie."""
        msg_text = self.font.render("Nouveau Record ! Entrez votre nom :", True, (0, 255, 255))
        input_text = self.font.render(name, True, (255, 255, 255)) 
        
        surface.blit(msg_text, (WINDOW_WIDTH // 2 - msg_text.get_width() // 2, WINDOW_HEIGHT - 120))
        surface.blit(input_text, (WINDOW_WIDTH // 2 - input_text.get_width() // 2, WINDOW_HEIGHT - 80))
