import json
import os

# Couleurs
BG_COLOR = (18, 18, 18)  # Anthracite (#121212)
SNAKE_COLOR = (0, 255, 136)  # Vert Néon (#00FF88)
FOOD_COLOR = (255, 0, 85)  # Rouge Néon (#FF0055)
TEXT_COLOR = (224, 224, 224) # Blanc Cassé (#E0E0E0)

# Dimensions
WINDOW_WIDTH = 800
WINDOW_HEIGHT = 600
BLOCK_SIZE = 20
FOOD_SPAWN_MARGIN = 3

# Difficultés (FPS)
DIFFICULTIES = {
    "EASY": 7,
    "MEDIUM": 15,
    "HARD": 20
}

# Chemins
SCORE_FILE = "highscores.json"

def load_highscores():
    """Charge les meilleurs scores depuis le fichier JSON."""
    if not os.path.exists(SCORE_FILE):
        return [{"name": "Ordi", "score": 0}] * 3
    try:
        with open(SCORE_FILE, "r") as f:
            scores = json.load(f)
            # S'assurer d'avoir toujours une liste valide
            if not isinstance(scores, list):
                return [{"name": "Ordi", "score": 0}] * 3
            return scores
    except (json.JSONDecodeError, IOError):
        return [{"name": "Ordi", "score": 0}] * 3

def save_highscore(name, score, highscores):
    """Met à jour et sauvegarde les meilleurs scores."""
    highscores.append({"name": name, "score": score})
    # Trier par score décroissant
    highscores.sort(key=lambda x: x["score"], reverse=True)
    # Garder les 3 meilleurs
    highscores = highscores[:3]
    
    try:
        with open(SCORE_FILE, "w") as f:
            json.dump(highscores, f)
    except IOError:
        print("Erreur lors de la sauvegarde des scores.")
    return highscores
