import pygame

def create_assets():
    pygame.init()
    size = 64
    
    # Floor (Light Gray with noise/texture)
    floor = pygame.Surface((size, size))
    floor.fill((200, 200, 190))
    pygame.draw.rect(floor, (190, 190, 180), (0, 0, size, size), 2)
    pygame.image.save(floor, "assets/floor.png")

    # Wall (Dark Gray Brick)
    wall = pygame.Surface((size, size))
    wall.fill((80, 80, 80))
    pygame.draw.rect(wall, (60, 60, 60), (0, 0, size, size), 4)
    pygame.draw.line(wall, (50, 50, 50), (0, size//2), (size, size//2), 2)
    pygame.draw.line(wall, (50, 50, 50), (size//2, 0), (size//2, size//2), 2)
    pygame.draw.line(wall, (50, 50, 50), (size//4, size//2), (size//4, size), 2)
    pygame.image.save(wall, "assets/wall.png")

    # Box (Brown Wooden Crate)
    box = pygame.Surface((size, size))
    box.fill((160, 110, 60))
    pygame.draw.rect(box, (130, 90, 50), (0, 0, size, size), 4)
    pygame.draw.line(box, (130, 90, 50), (0, 0), (size, size), 2)
    pygame.draw.line(box, (130, 90, 50), (size, 0), (0, size), 2)
    pygame.draw.rect(box, (140, 100, 55), (10, 10, size-20, size-20), 2)
    pygame.image.save(box, "assets/box.png")

    # Target (Red Cross/Circle on transparent)
    target = pygame.Surface((size, size), pygame.SRCALPHA)
    pygame.draw.circle(target, (200, 50, 50, 200), (size//2, size//2), size//4)
    pygame.draw.circle(target, (255, 100, 100, 255), (size//2, size//2), size//5)
    pygame.image.save(target, "assets/target.png")

    # Player (Blue Character)
    player = pygame.Surface((size, size), pygame.SRCALPHA)
    # Body
    pygame.draw.circle(player, (50, 50, 200), (size//2, size//2), size//3)
    # Cap
    pygame.draw.circle(player, (30, 30, 150), (size//2, size//2 - 5), size//4)
    # Eyes
    pygame.draw.circle(player, (255, 255, 255), (size//2 - 8, size//2 - 5), 4)
    pygame.draw.circle(player, (255, 255, 255), (size//2 + 8, size//2 - 5), 4)
    pygame.image.save(player, "assets/player.png")

    # Box on Target (Gold)
    box_done = pygame.Surface((size, size))
    box_done.fill((200, 170, 50))
    pygame.draw.rect(box_done, (255, 255, 255), (0, 0, size, size), 4)
    pygame.draw.line(box_done, (255, 220, 100), (0, 0), (size, size), 2)
    pygame.draw.line(box_done, (255, 220, 100), (size, 0), (0, size), 2)
    pygame.image.save(box_done, "assets/box_done.png")

    print("Assets generated.")

if __name__ == "__main__":
    create_assets()
