# Sokoban - Édition Python

Bienvenue dans cette version classique du jeu de réflexion Sokoban, développée en Python avec la bibliothèque Pygame.

## Objectifs du Jeu
Le but est simple mais le défi est grand :
- Vous incarnez un gardien d'entrepôt.
- Vous devez pousser toutes les caisses (marron) sur les emplacements cibles (points rouges).
- **Règles importantes** :
  - Vous ne pouvez pousser qu'une seule caisse à la fois.
  - Vous ne pouvez **pas** tirer les caisses.
  - Attention à ne pas coincer les caisses dans les coins ou contre les murs !

## Contenu du Package
Ce dossier contient l'intégralité du code source du projet :
- **main.py** : Le point d'entrée principal pour lancer le jeu.
- **src/** : Le code source du jeu (Logique, Vue, Contrôleur).
- **assets/** : Les images et ressources graphiques.
- **levels/** : Les fichiers de niveaux.
- **Outils pour les développeurs** :
  - `generate_assets.py` : Script pour régénérer les assets graphiques procéduraux.
  - `regenerate_levels.py` : Script pour générer de nouveaux niveaux aléatoires.

## Dépendances
Ce jeu nécessite l'installation de :
- Python 3.10 ou supérieur.
- La bibliothèque `pygame` (gestion graphique et sonore).

(Voir le fichier `install.md` pour le guide d'installation complet).

## Utilisation et Contrôles
Une fois le jeu lancé (`python main.py`), utilisez les touches suivantes :

| Touche | Action |
| :--- | :--- |
| **Flèches Directionnelles** | Déplacer le personnage (Haut, Bas, Gauche, Droite) |
| **U** | **Annuler** le dernier mouvement (Undo) |
| **R** | **Recommencer** le niveau actuel (Restart) |
| **G** | **Générer** un nouveau niveau aléatoire (depuis le Menu principal) |
| **Échap (Esc)** | Quitter le niveau vers le menu / Quitter le jeu |
| **Entrée (Enter)** | Lancer le jeu depuis le menu / Passer au niveau suivant après une victoire |

## Améliorations Possibles
Ce projet est une base solide qui peut être étendue. Voici quelques idées d'améliorations pour les développeurs ou passionnés :
1. **Éditeur de Niveaux** : Créer une interface pour dessiner et sauvegarder ses propres niveaux.
2. **Skins et Thèmes** : Permettre de changer l'apparence des graphismes (personnage, caisses, sol).
3. **Audio** : Ajouter des bruitages lors des déplacements et une musique de fond.
4. **Meilleurs Scores** : Sauvegarder le nombre de mouvements ou le temps pour chaque niveau.
5. **Support Mobile** : Adapter les contrôles pour une interface tactile ou une version web (via Pygbag par exemple).
6. **IA de Résolution** : Intégrer un algorithme qui montre la solution d'un niveau.

Amusez-vous bien !
