from src.generator import LevelGenerator

def generate_all():
    print("Generating 40 levels of increasing difficulty...")
    
    for i in range(1, 41):
        # Progression logic
        # Width/Height: Starts at 9, increases slowly
        size = int(9 + (i / 6)) # Level 1=9, Level 40=15
        
        # Boxes: Starts at 2, increases
        boxes = int(2 + (i / 8)) # Level 1=2, Level 40=7
        
        # Steps: Measures "shuffling" depth
        steps = int(200 + (i * 100)) # Level 1=300, Level 40=4200
        
        gen = LevelGenerator(width=size, height=size)
        lines = gen.generate_level(num_boxes=boxes, diff_steps=steps)
        
        filename = f"levels/level{i}.txt"
        with open(filename, "w") as f:
            f.writelines(lines)
            
        print(f"Generated {filename} (Size: {size}x{size}, Boxes: {boxes}, Steps: {steps})")

    print("Done generating 40 levels.")

if __name__ == "__main__":
    generate_all()
