class GameModel:
    def __init__(self):
        self.level = None
        self.player_pos = None
        self.boxes = []
        self.targets = []
        self.walls = []
        self.width = 0
        self.height = 0
        self.moves = 0
        self.history = []
        self.current_level = 1

    def load_level(self, level_file):
        # Extract level number from filename if possible, or just use a counter passed in
        # For now, let's trust the controller to set current_level or parse it here if needed.
        # Simple parsing:
        try:
             import re
             match = re.search(r'level(\d+)', level_file)
             if match:
                 self.current_level = int(match.group(1))
        except:
            pass

        with open(level_file, 'r') as f:
            lines = f.readlines()
        
        self.walls = []
        self.boxes = []
        self.targets = []
        self.history = []
        self.moves = 0
        self.height = len(lines)
        self.width = max(len(line.strip()) for line in lines) if lines else 0
        
        for y, line in enumerate(lines):
            for x, char in enumerate(line.strip()):
                if char == '#':
                    self.walls.append((x, y))
                elif char == '@':
                    self.player_pos = (x, y)
                elif char == '$':
                    self.boxes.append((x, y))
                elif char == '.':
                    self.targets.append((x, y))
                elif char == '*': # Box on target
                    self.boxes.append((x, y))
                    self.targets.append((x, y))
                elif char == '+': # Player on target
                    self.player_pos = (x, y)
                    self.targets.append((x, y))

    def move_player(self, dx, dy):
        if not self.player_pos:
            return

        new_x = self.player_pos[0] + dx
        new_y = self.player_pos[1] + dy

        if (new_x, new_y) in self.walls:
            return

        # Save state for undo
        current_state = {
            'player_pos': self.player_pos,
            'boxes': list(self.boxes),
            'moves': self.moves
        }

        moved = False
        if (new_x, new_y) in self.boxes:
            box_new_x = new_x + dx
            box_new_y = new_y + dy
            
            if (box_new_x, box_new_y) in self.walls or (box_new_x, box_new_y) in self.boxes:
                return
            
            # Move box
            self.boxes.remove((new_x, new_y))
            self.boxes.append((box_new_x, box_new_y))
            moved = True
        else:
            moved = True

        if moved:
            self.history.append(current_state)
            self.player_pos = (new_x, new_y)
            self.moves += 1

    def undo(self):
        if not self.history:
            return
        
        last_state = self.history.pop()
        self.player_pos = last_state['player_pos']
        self.boxes = last_state['boxes']
        self.moves = last_state['moves']

    def check_win(self):
        if not self.boxes: return False
        for box in self.boxes:
            if box not in self.targets:
                return False
        return True
