# Guide d'Installation - Optimiseur de Mémoire

## Pré-requis
Cette application est conçue pour fonctionner sur **Linux** (Debian, Ubuntu, Raspberry Pi OS, etc.).

Elle nécessite :
1.  **Python 3** (installé par défaut sur la plupart des distributions).
2.  **Tkinter** (pour l'interface graphique).
3.  Droits d'administration (**sudo**).

## Installation

### 1. Extraction
Décompressez l'archive `swap_installer.zip` dans le dossier de votre choix :
```bash
unzip swap_installer.zip -d optimiseur_memoire
cd optimiseur_memoire
```

### 2. Installation des dépendances
Sur certaines versions minimales de Linux (comme Raspberry Pi OS Lite), l'interface graphique Tkinter peut manquer. Installez-la avec :

```bash
sudo apt update
sudo apt install python3-tk unzip
```
*(Le paquet `unzip` est pour décompresser l'archive si ce n'est pas déjà fait).*

### 3. Permissions
Rendez les scripts exécutables :
```bash
chmod +x config_swap.py swap_gui.py
```

## Lancement

### Interface Graphique (Recommandé)
Lancez l'application avec les droits administrateur pour pouvoir appliquer les changements :
```bash
sudo python3 swap_gui.py
```

### Ligne de Commande (Serveurs)
Si vous n'avez pas d'écran, utilisez le script de configuration en mode texte :
```bash
sudo python3 config_swap.py --help
```

## Désinstallation
Pour désinstaller l'application (et annuler ses effets sur le système) :
1.  Lancez l'application et cliquez sur **"Désinstaller Tout"**.
2.  Ou en ligne de commande : `sudo python3 config_swap.py --uninstall`
3.  Supprimez ensuite le dossier de l'application.
