# Optimiseur de Mémoire (Swap/Zram)

## Objectifs du Projet
Ce projet fournit une solution clé en main pour optimiser la gestion de la mémoire sur les systèmes Linux, particulièrement adaptée aux nanordinateur comme le Raspberry Pi 5.

Il permet de :
*   Créer et configurer facilement un **Swapfile** (mémoire virtuelle sur disque).
*   Installer et régler **Zram** (compression de la RAM) pour améliorer les performances.
*   Ajuster la **Swappiness** (priorité d'utilisation du swap).
*   Offrir une interface pédagogique pour comprendre ces concepts.

## Dépendances

### Logiciel
*   **Python 3.x**
*   **Tkinter** (bibliothèque graphique standard de Python).
*   **Outils système Linux** (vérifiés automatiquement au lancement) : `mkswap`, `swapon`, `fallocate`, `sysctl`, `apt` (pour Zram).

### Matériel
*   Tout ordinateur sous Linux (x86 ou ARM/Raspberry Pi).

## Utilisation

### Interface Graphique (GUI)
Le fichier `swap_gui.py` lance une fenêtre en mode sombre, facile à utiliser.
*   **Swapfile** : Réglez la taille avec le premier curseur.
*   **Zram** : Réglez le pourcentage de compression (recommandé : 50%).
*   **Swappiness** : Réglez la priorité (recommandé : 20).
*   **Aide** : Cliquez sur le bouton **"?"** pour des explications détaillées.

Commandes :
*   **Appliquer** : Configure le système.
*   **Restaurer** : Revient à la configuration avant modification.
*   **Désinstaller** : Supprime tout (nettoyage propre).

### Ligne de Commande (CLI)
Le fichier `config_swap.py` est le moteur de l'application. Il peut être utilisé seul pour l'automatisation.
Exemple : `sudo python3 config_swap.py --swap-size 4 --zram-percent 50 --yes`

## Améliorations Possibles
*   Ajout d'un graphique historique de l'utilisation mémoire.
*   Traduction de l'interface (actuellement en français uniquement).
*   Création d'un service systemd pour vérifier la config au démarrage.
*   Support des gestionnaires de paquets autres que `apt` (ex: `dnf`, `pacman`).
